/*
 * lib/pg_statsinfo.sql.in
 *
 * Copyright (c) 2010, NIPPON TELEGRAPH AND TELEPHONE CORPORATION
 */

-- Adjust this setting to control where the objects get created.
SET search_path = public;

BEGIN;

SET LOCAL client_min_messages = WARNING;

CREATE SCHEMA statsinfo;
REVOKE ALL ON SCHEMA statsinfo FROM PUBLIC;

--
-- statsinfo.sample()
--
CREATE FUNCTION statsinfo.sample() RETURNS void
AS '$libdir/pg_statsinfo', 'statsinfo_sample'
LANGUAGE C STRICT;

--
-- statsinfo.activity()
--
CREATE FUNCTION statsinfo.activity(
	OUT idle			float8,
	OUT idle_in_xact	float8,
	OUT waiting			float8,
	OUT running			float8,
	OUT client			text,
	OUT pid				integer,
	OUT start			timestamptz,
	OUT duration		float8,
	OUT query			text
)
AS '$libdir/pg_statsinfo', 'statsinfo_activity'
LANGUAGE C STRICT;

--
-- statsinfo.snapshot()
--
CREATE FUNCTION statsinfo.snapshot(comment text) RETURNS void
AS '$libdir/pg_statsinfo', 'statsinfo_snapshot'
LANGUAGE C;

CREATE FUNCTION statsinfo.snapshot() RETURNS void
AS '$libdir/pg_statsinfo', 'statsinfo_snapshot'
LANGUAGE C;

--
-- statsinfo.tablespaces()
--
CREATE FUNCTION statsinfo.tablespaces(
	OUT oid oid,
	OUT name text,
	OUT location text,
	OUT device text,
	OUT avail bigint,
	OUT total bigint,
	OUT spcoptions text[])
RETURNS SETOF record
AS '$libdir/pg_statsinfo', 'statsinfo_tablespaces'
LANGUAGE C STRICT;

CREATE VIEW statsinfo.tablespaces AS
	SELECT * FROM statsinfo.tablespaces();

--
-- statsinfo.restart()
--
CREATE FUNCTION statsinfo.restart() RETURNS text
AS '$libdir/pg_statsinfo', 'statsinfo_restart'
LANGUAGE C;

COMMIT;
